#include "stm32f10x_gpio.h"
#include "stm32f10x_rcc.h"

#define SDA_LN          GPIO_Pin_7                     // SDA
#define I2C_SDA_PORT    GPIOB                          // 

#define SCL_LN          GPIO_Pin_6                     // SCL
#define I2C_SCL_PORT   	GPIOB                          // 

#define pause			10

#define IN_LN           0                               //  
#define OUT_LN          1                               //  

uint8_t i2c_error;                           			// >0,       I2C
GPIO_InitTypeDef I2C_GPIO_InitStructure;

// 

void i2c_init(void);
void i2c_start(void);
void i2c_stop(void);
void i2c_tx(uint8_t byte);
uint8_t i2c_rx(uint8_t last_byte);
uint8_t in_sda(void);
void sda_io(uint8_t io_c);
void scl_set(uint8_t set_c);
void sda_set(uint8_t set_c);

//   I2C
void i2c_init(void)
	{
	//  SDA
	// SCL   
	//       
	// 
	
	// Enable PORTC Periph clock  
  	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
 	
	I2C_GPIO_InitStructure.GPIO_Pin = SDA_LN;
  	I2C_GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  	I2C_GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  	GPIO_Init(I2C_SDA_PORT, &I2C_GPIO_InitStructure);

	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
 	
	I2C_GPIO_InitStructure.GPIO_Pin = SCL_LN;
  	I2C_GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  	I2C_GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  	GPIO_Init(I2C_SCL_PORT, &I2C_GPIO_InitStructure);

	i2c_error=0; //   :-)
	}

//   SDA
unsigned char in_sda(void)
	{
  	if((GPIO_ReadInputDataBit(I2C_SDA_PORT, SDA_LN))) return 1;
  		else return 0;
	}

//  SDA    
void sda_io(uint8_t io_c)
	{
	uint16_t i = pause;

	if (io_c==IN_LN) 
		{
		RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
 		I2C_GPIO_InitStructure.GPIO_Pin = SDA_LN;
  		I2C_GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  		I2C_GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  		GPIO_Init(I2C_SDA_PORT, &I2C_GPIO_InitStructure);
		}
	while (--i > 0) __NOP();
	}

//    SCL
void scl_set(uint8_t set_c)
	{
	uint16_t i = pause;

	if(set_c)
		{
		RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
 		I2C_GPIO_InitStructure.GPIO_Pin = SCL_LN;
  		I2C_GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  		I2C_GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  		GPIO_Init(I2C_SCL_PORT, &I2C_GPIO_InitStructure);
		}
    	else 
			{
			RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
 			I2C_GPIO_InitStructure.GPIO_Pin = SCL_LN;
  			I2C_GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  			I2C_GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  			GPIO_Init(GPIOB, &I2C_GPIO_InitStructure);
			GPIO_ResetBits(I2C_SCL_PORT, SCL_LN);
			}
	while (--i > 0) __NOP();
	}

//    SDA
void sda_set(uint8_t set_c)
	{
	uint16_t i = pause;

	if(set_c)
		{
		RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
 		I2C_GPIO_InitStructure.GPIO_Pin = SDA_LN;
  		I2C_GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  		I2C_GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
  		GPIO_Init(I2C_SDA_PORT, &I2C_GPIO_InitStructure);
		}
    	else 
			{
			RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
 			I2C_GPIO_InitStructure.GPIO_Pin = SDA_LN;
  			I2C_GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
  			I2C_GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
  			GPIO_Init(GPIOB, &I2C_GPIO_InitStructure);
			GPIO_ResetBits(I2C_SDA_PORT, SDA_LN);
			}

	while (--i > 0) __NOP();
	}

//  ""
void i2c_start(void)
	{
  	if(i2c_error) return;
  	scl_set(1);
  	sda_set(0);
  	scl_set(0);
	}

//  ""
void i2c_stop(void)
	{
  	sda_set(0);
  	scl_set(1);
  	sda_set(1);
  	if(i2c_error) i2c_init();
 	}

// 
void i2c_tx(uint8_t byte)
	{
  	uint8_t i=0;
  
  	if(i2c_error) return;
  	for(i=0;i<8;i++)
    	{
      	if(byte&0x80) sda_set(1);
      		else sda_set(0);
      	scl_set(1);
      	scl_set(0);
      	byte<<=1;
		}
  	sda_io(IN_LN);
  	scl_set(1);
  	i2c_error=in_sda();
  	scl_set(0);
  	sda_io(OUT_LN);
	}

// ,  last_byte=0,          
uint8_t i2c_rx(uint8_t last_byte)
	{
  	uint8_t data=0;
  	uint8_t mask=0x80;
  	uint8_t i=0;
  	if(i2c_error) return 0;
  	sda_io(IN_LN);
  	for(i=0;i<8;i++)
    	{
      	scl_set(1);
      	if(in_sda()) data=data+mask;
      	mask>>=1;
      	scl_set(0);
    	}
  	sda_io(OUT_LN);
  	if(last_byte) sda_set(0);
  		else sda_set(1);
  	scl_set(1);
  	scl_set(0);
  	return data;
	}

